<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_Model_SSH
{
	/**
	 * Instance manager.
	 */
	private static $_instance;
	
	/*
	 * Registered Bot Checking Services
	 */
	public $services;
	
    public $visitor;
    public $options;
    
    public $registerCheck;
    public $registerCheckField;
    
    public $registerMinimumSubmitTime;
    
    public $registerAction;
    
    public $registerCheckPoint;
    public $registerCheckPointLimit;
    public $registerCheckPointIP;
    public $registerCheckPointUsername;
    public $registerCheckPointEmail;
    public $registerCheckPointAction;

    public $actionLink;
    public $linkCheckNodes;
    
    public $actionKeyword;
    public $keywordList;
    public $keywordCheckNodes;

    public $actionAkismet;
    public $akismetCheckNodes;
    
    const TYPE_THREAD = 'thread';
    const TYPE_POST = 'post';
    const TYPE_PROFILE_POST = 'profile';
    const TYPE_PROFILE_POST_COMMENT = 'comment';
    const TYPE_CONVERSATION = 'conversation';
    const TYPE_CONVERSATION_REPLY = 'conversation_reply';
    const TYPE_REGISTER = 'register';
    const TYPE_PERSONALDETAIL = 'personal_detail';
    const TYPE_SIGNATURE = 'signature';
    
    const ACTION_ALLOW = 'allow';
    const ACTION_MODERATE = 'moderate';
    const ACTION_DISCOURAGED = 'discouraged';
    const ACTION_REPORT = 'report';
    const ACTION_CONVERSATION = 'pc';
    const ACTION_BLOCK = 'block';
    
    const LOG_TYPE_LINK = 'link';
    const LOG_TYPE_KEYWORD = 'keyword';
    const LOG_TYPE_AKISMET = 'akismet';
    const LOG_TYPE_REGISTER = 'register';

    public static function getInstance()
    {
    	if (!self::$_instance)
    	{
    		$object = new self();
    		
    		$object->visitor = XenForo_Visitor::getInstance();
    		$object->options = XenForo_Application::getOptions();
    		
    		$object->registerAction = $object->options->sonnbStopSpamHere_registration_action;
    		
    		$object->registerCheck = $object->options->sonnbStopSpamHere_registration;
    		$object->registerCheckField = $object->options->sonnbStopSpamHere_registration_checkOn;
    		
    		$object->registerMinimumSubmitTime = $object->options->sonnbStopSpamHere_registration_submitTime;
    		
    		$object->registerCheckPoint = $object->options->sonnbStopSpamHere_PointSystem;
    		$object->registerCheckPointLimit = $object->options->sonnbStopSpamHere_PointSystem_Point;
    		$object->registerCheckPointIP = $object->options->sonnbStopSpamHere_PointSystem_Ip;
    		$object->registerCheckPointEmail = $object->options->sonnbStopSpamHere_PointSystem_Email;
    		$object->registerCheckPointUsername = $object->options->sonnbStopSpamHere_PointSystem_User;
    		$object->registerCheckPointAction = $object->options->sonnbStopSpamHere_PointSystem_Action;
    		
    		$object->actionLink = $object->options->sonnbStopSpamHere_linkAction;
    		$object->linkCheckNodes = $object->options->sonnbStopSpamHere_linkNodes;
    		
    		$object->actionKeyword = $object->options->sonnbStopSpamHere_keywordAction;
    		$object->keywordList = preg_split( '/\r\n|\r|\n/', $object->options->sonnbStopSpamHere_keywordList, -1, PREG_SPLIT_NO_EMPTY);
    		$object->keywordCheckNodes = $object->options->sonnbStopSpamHere_keywordNodes;
    		
    		$object->actionAkismet = $object->options->sonnbStopSpamHere_post_action;
    		$object->akismetCheckNodes = $object->options->sonnbStopSpamHere_post_nodes;
    		
    		/*
    		 * Call event load service that would load another Bot Checking API
    		 */
    		if (!$object->services)
    		{
    			$object->services = array();
    		}
    		XenForo_CodeEvent::fire('sonnb_StopSpamHere_BotServicesLoad', array(&$object->services));
    		
    		self::$_instance = $object;
    	}
    	
    	return self::$_instance;
    }
    
    public function _hasLinkCheck($action)
    {
    	if ($this->visitor->hasPermission('sonnbSSH', 'bypass_link'))
    	{
    		return false;
    	}
    	
        return ($this->options->sonnbStopSpamHere_linkCheck && 
                isset($this->options->sonnbStopSpamHere_linkCheckOn[$action]) &&
                (
                    !$this->options->sonnbStopSpamHere_linkDisabledPostCount ||
                    (
                        $this->options->sonnbStopSpamHere_linkDisabledPostCount &&
                        $this->options->sonnbStopSpamHere_linkDisabledPostCount > $this->visitor['message_count']
                    )
                ) &&
                (
                    !$this->options->sonnbStopSpamHere_linkDisabledJoinDate ||
                    (
                        $this->options->sonnbStopSpamHere_linkDisabledJoinDate && 
                        $this->visitor['register_date'] - strtotime('- '.$this->options->sonnbStopSpamHere_linkDisabledJoinDate.' days') > 0
                    )
                ) 
            );
    }
    
    public function checkLink($contentType, $contentId, $message)
    {
        $message = XenForo_Helper_String::autoLinkBbCode($message);
        
        $result = preg_match_all('/\[URL.*?\].*?\[\/URL\]/siU', $message, $matchLinks);
        
        if ($result)
        {
            $data = array('matchLinks' => $matchLinks);
            
            switch ($contentType)
            {
                case sonnbStopSpamHere_Model_SSH::TYPE_CONVERSATION:
                case sonnbStopSpamHere_Model_SSH::TYPE_CONVERSATION_REPLY:
                case sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST_COMMENT:
                case sonnbStopSpamHere_Model_SSH::TYPE_SIGNATURE:
                case sonnbStopSpamHere_Model_SSH::TYPE_PERSONALDETAIL:
                    $data += array('message' => $message);
                    break;
            }
            
            if (in_array($this->actionLink, array(self::ACTION_BLOCK)))
            {
                $this->saveLog(array(
                    'content_type' => $contentType,
                    'content_id' => $contentId,
                    'log_type' => self::LOG_TYPE_LINK,
                    'data' => serialize($data),
                    'action' => $this->actionLink
                ));
            }


            return array(
                'action' => $this->actionLink,
                'data' => $data
            );
        }
        else
        {
            return false;
        }
    }
    
    public function _hasKeywordCheck($action)
    {
    	if ($this->visitor->hasPermission('sonnbSSH', 'bypass_keyword'))
    	{
    		return false;
    	}

        return ($this->options->sonnbStopSpamHere_keywordCheck &&
                isset($this->options->sonnbStopSpamHere_keywordCheckOn[$action]) &&
                !empty($this->options->sonnbStopSpamHere_keywordList) &&
                (
                    !$this->options->sonnbStopSpamHere_keywordDisabledPostCount ||
                    (
                        $this->options->sonnbStopSpamHere_keywordDisabledPostCount &&
                        $this->options->sonnbStopSpamHere_keywordDisabledPostCount > $this->visitor['message_count']
                    )
                ) &&
                (
                    !$this->options->sonnbStopSpamHere_keywordDisabledJoinDate ||
                    (
                        $this->options->sonnbStopSpamHere_keywordDisabledJoinDate && 
                    	$this->visitor['register_date'] - strtotime('- '.$this->options->sonnbStopSpamHere_keywordDisabledJoinDate.' days') > 0
                    )
                )
            );
    }
    
    public function checkKeyword($contentType, $contentId, $message)
    {
        $message = XenForo_Helper_String::autoLinkBbCode($message);
        
        $matches = array();
        foreach ($this->keywordList as $keyword)
        {
            $keyAction = explode('=>', $keyword);

            $pattern = '#(?<=\W|^)(' . preg_quote($keyAction[0], '#') . ')(?=\W|$)#iu';
            $patternCheck = preg_match_all($pattern, $message, $keywordMatches);
            
            if ($patternCheck)
            {
                if (sizeof($keyAction) == 1 || empty($keyAction[1]))
                {
                    $matches[$keyAction[0]] = $this->actionKeyword;
                }
                else
                {
                    $matches[$keyAction[0]] = $keyAction[1];
                }
            }
        }
        
        if (!empty($matches))
        {
            $data = array('matches' => array_keys($matches));
            
            switch ($contentType)
            {
                case sonnbStopSpamHere_Model_SSH::TYPE_CONVERSATION:
                case sonnbStopSpamHere_Model_SSH::TYPE_CONVERSATION_REPLY:
                case sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST_COMMENT:
                case sonnbStopSpamHere_Model_SSH::TYPE_SIGNATURE:
                case sonnbStopSpamHere_Model_SSH::TYPE_PERSONALDETAIL:
                    $data += array('message' => $message);
                    break;
            }
            
            if (in_array(self::ACTION_BLOCK, array_values($matches)))
            {
                $action = self::ACTION_BLOCK;
            }
            elseif (in_array(self::ACTION_MODERATE, array_values($matches)))
            {
                $action = self::ACTION_MODERATE;
            }
            elseif (in_array(self::ACTION_CONVERSATION, array_values($matches)))
            {
                $action = self::ACTION_CONVERSATION;
            }
            elseif (in_array(self::ACTION_REPORT, array_values($matches)))
            {
                $action = self::ACTION_REPORT;
            }
            else
            {
                $action = self::ACTION_ALLOW;
            }

            if (in_array($action, array(self::ACTION_BLOCK)))
            {
                $this->saveLog(array(
                    'content_type' => $contentType,
                    'content_id' => $contentId,
                    'log_type' => self::LOG_TYPE_KEYWORD,
                    'data' => serialize($data),
                    'action' => $action
                ));
            }
            
            return array(
                'action' => $action,
                'data' => $data
            );
        }
        else
        {
            return false;
        }
    }
    
    public function _hasAkismetCheck($action)
    {
    	if ($this->visitor->hasPermission('sonnbSSH', 'bypass_akismet'))
    	{
    		return false;
    	}
    	
        return ($this->options->sonnbStopSpamHere_post && 
                isset($this->options->sonnbStopSpamHere_post_checkOn[$action]) &&
                !empty($this->options->sonnbStopSpamHere_post_api) &&
                (
                    !$this->options->sonnbStopSpamHere_post_disabledPostCount ||
                    (
                        $this->options->sonnbStopSpamHere_post_disabledPostCount &&
                        $this->options->sonnbStopSpamHere_post_disabledPostCount > $this->visitor['message_count']
                    )
                ) && 
                (
                    !$this->options->sonnbStopSpamHere_post_disabledJoinDate ||
                    (
                        $this->options->sonnbStopSpamHere_post_disabledJoinDate && 
                        $this->visitor['register_date'] - strtotime('- '.$this->options->sonnbStopSpamHere_post_disabledJoinDate.' days') > 0
                    )
                ) 
            );
    }
    
    public function checkAkismet($contentType, $contentId, $message)
    {
        $message = XenForo_Helper_String::autoLinkBbCode($message);
        
        $akismet = new sonnbStopSpamHere_Model_Askimet;
        $params = array(
            'user_ip' => $this->getUserIP(),
            'user_agent' => (isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : ''),
            'referrer' => (isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : ''),
            'comment_type' => 'comment',
            'comment_author' => $this->visitor['username'],
            'comment_author_email' => $this->visitor['email'],
            'comment_content' => $message
        );
        
        if ($akismet->isSpam($params))
        {
            $data = array();
            
            switch ($contentType)
            {
                case sonnbStopSpamHere_Model_SSH::TYPE_CONVERSATION:
                case sonnbStopSpamHere_Model_SSH::TYPE_CONVERSATION_REPLY:
                case sonnbStopSpamHere_Model_SSH::TYPE_PROFILE_POST_COMMENT:
                case sonnbStopSpamHere_Model_SSH::TYPE_SIGNATURE:
                case sonnbStopSpamHere_Model_SSH::TYPE_PERSONALDETAIL:
                    $data = array('message' => $message);
                    break;
            }
            
            if (in_array($this->actionAkismet, array(self::ACTION_BLOCK)))
            {
                $this->saveLog(array(
                    'content_type' => $contentType,
                    'content_id' => $contentId,
                    'log_type' => self::LOG_TYPE_AKISMET,
                    'data' => serialize($data),
                    'action' => $this->actionAkismet
                ));
            }
            
            return array(
                'action' => $this->actionAkismet,
                'data' => $data
            );
        }
        else
        {
            return false;
        }
    }
    
    public function checkRegister(array $data)
    {        
        if (!empty($this->services))
        {
            if (!isset($this->registerCheckField['username']) && isset($data['username']))
            {
                $data['username'] = '';
            }

            if (!isset($this->registerCheckField['email']) && isset($data['email']))
            {
                $data['email'] = '';
            }

            if (!isset($this->registerCheckField['ip']) && isset($data['ip']))
            {
                $data['ip'] = 0;
            }

            foreach ($this->services as $service)
            {
                $spammer = $service->checkRegister($data);

                if ($spammer)
                {
                    if (!empty($spammer['email']) || !empty($spammer['ip']))
                    {
                        return array(
                            'action' => $this->registerAction,
                            'data' => $data+array('service' => get_class($service))
                        );
                    }
                }
            }
        }
            
        return false;
    }
    
    public function getPointIP()
    {
        $ipCheck = $this->getUserIP();
        $point = 0;
        
        if ($ipCheck && $this->registerCheckPointIP)
        {
            $ipArray = preg_split( '/\r\n|\r|\n/', $this->registerCheckPointIP);
            foreach ($ipArray as $ip_item)
            {
                list($ip, $point_ip) = explode('=>', $ip_item);
                list($ip_range, $ip_subnet) = explode('/', $ip);

                if ((ip2long($ipCheck) & ~((1 << (32 - $ip_subnet)) - 1)) == ip2long ($ip_range))
                {
                    $point += $point_ip;
                    break;
                }
            }
        }
        
        return $point;
    }
    
    public function getPointEmail($email)
    {
        $point = 0;
        
        if ($email && $this->registerCheckPointEmail)
        {
            $emailArray = preg_split( '/\r\n|\r|\n/', $this->registerCheckPointEmail);
            foreach ($emailArray as $email_item)
            {
                list ($address, $domain) = explode('@', $email);
                list ($email_domain, $email_point) = explode('=>', $email_item);

                if (!empty($domain) && $domain == $email_domain)
                {
                    $point += $email_point;
                    break;
                }
            }
        }
            
        return $point;
    }
    
    public function getPointUsername($usernameCheck)
    {
        $point = 0;
        
        if ($usernameCheck && $this->registerCheckPointUsername)
        {
            $usernameArray = preg_split( '/\r\n|\r|\n/', $this->registerCheckPointUsername);
            foreach ($usernameArray as $username_item)
            {
                list ($user_name, $user_point) = explode('=>', $username_item);

                $pattern = '#(?<=\W|^)(' . preg_quote($user_name, '#') . ')(?=\W|$)#iu';

                $patternCheck = preg_match_all($pattern, $usernameCheck, $matches);

                if ($patternCheck)
                {
                    $point += $user_point;
                }
            }
        }
            
        return $point;
    }
    
    public function checkPointLimit($point)
    {
        if ($point > $this->registerCheckPointLimit)
        {
            return $this->registerCheckPointAction;
        }
        
        return false;
    }
    
    public function getUserIP()
    {
        $ip = 0;
        
        if(isset($_SERVER["HTTP_X_FORWARDED_FOR"]))
        {
            /*
             * Just for reference purpose
             *
            if(isset($_SERVER["HTTP_CLIENT_IP"]))
            {
                $proxy = $_SERVER["HTTP_CLIENT_IP"];
            }
            else
            {
                $proxy = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 0;
            }
             * 
             */

            $ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
        }
        else
        {
            if(isset($_SERVER["HTTP_CLIENT_IP"]))
            {
                $ip = $_SERVER["HTTP_CLIENT_IP"];
            }
            else
            {
                $ip = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 0;
            }
        }

        return $ip;
    }
    
    public function saveLog(array $data)
    {
        $userData = array(
            'username' => $this->visitor['username'],
            'email' => $this->visitor['email'],
            'ip' => $this->getUserIP(),
            'user_id' => $this->visitor['user_id'],
            'time' => XenForo_Application::$time
        );
        
        $bulkData = array_merge($userData, $data);
        
        $logDw = XenForo_DataWriter::create('sonnbStopSpamHere_DataWriter_Log', XenForo_DataWriter::ERROR_SILENT);
        $logDw->bulkSet($bulkData);
        $logDw->save();
    }
}

?>
